<?php
    // Default Values for Row Toggles
    $this->TS_VCSC_Row_Toggle_Defaults = array(
        'Large Devices'                 => 1200,
        'Medium Devices'                => 992,
        'Small Devices'                 => 768,
    );
    
    // Default Values for Screen Sizes
    $this->TS_VCSC_Screen_Sizes_Defaults = array(
        'ExtraLarge'                    => 1440,
        'Large'                         => 1024,
        'Medium'                        => 720,
        'Small'                         => 360,
        'ExtraSmall'                    => 0,
    );
    
    // Default Advanced Link Picker
    $this->TS_VCSC_Advanced_Linkpicker_Defaults = array(
        'enabled'                       => 0, // true/false
        'global'                        => 1,
        'offset'                        => 25,
        'posts'                         => 1, // true/false
        'custom'                        => 0, // true/false
        'orderby'                       => 'title',
        'order'                         => 'ASC',
    );
    
    // Default Numeric Slider Input (noUiSlider)
    $this->TS_VCSC_NoUiSlider_Inputs_Defaults = array(
        'enabled'                       => 1, // true/false
        'pips'                          => 1, // true/false
        'tooltip'                       => 1, // true/false
        'input'                         => 1, // true/false
    );

    // Default Text Strings for TS Isotope Posts
    $this->TS_VCSC_Isotope_Posts_Language_Defaults = array(
        'ButtonFilter'		            => 'Filter Posts',        
        'ButtonLayout'		            => 'Change Layout',
        'ButtonSort'		            => 'Sort Criteria',
        // Standard Post Strings
        'Date' 				            => 'Post Date',        
        'Modified' 			            => 'Post Modified',        
        'Title' 			            => 'Post Title',        
        'Author' 			            => 'Post Author',        
        'PostID' 			            => 'Post ID',        
        'Comments' 			            => 'Number of Comments',
        // Layout Strings
        'SeeAll'			            => 'See All',
        'Timeline' 			            => 'Timeline',
        'Masonry' 			            => 'Centered Masonry',
        'FitRows'			            => 'Fit Rows',
        'StraightDown' 		            => 'Straigt Down',
        // WooCommerce Strings
        'WooFilterProducts'             => 'Filter Products',
        'WooTitle'                      => 'Product Title',
        'WooPrice'                      => 'Product Price',
        'WooRating'                     => 'Product Rating',
        'WooDate'                       => 'Product Date',
        'WooModified'                   => 'Product Modified',
        // General Strings
        'Categories'                    => 'Categories',
        'Tags'                          => 'Tags',
    );
    
    // Default Text Strings for TS Countdown
    $this->TS_VCSC_Countdown_Language_Defaults = array(
        'DayPlural'                     => 'Days',
        'DaySingular'                   => 'Day',
        'HourPlural'                    => 'Hours',
        'HourSingular'                  => 'Hour',
        'MinutePlural'                  => 'Minutes',
        'MinuteSingular'                => 'Minute',
        'SecondPlural'                  => 'Seconds',
        'SecondSingular'                => 'Second',
    );
    
    // Default Text Strings for TS Image Magnify
    $this->TS_VCSC_Magnify_Language_Defaults = array(
        'ZoomIn'                        => 'Zoom In',
        'ZoomOut'                       => 'Zoom Out',
        'ZoomLevel'                     => 'Zoom Level',
        'ChangeLevel'                   => 'Change Zoom Level',
        'Next'                          => 'Next',
        'Previous'                      => 'Previous',
        'Reset'                         => 'Reset Zoom',
        'Rotate'                        => 'Rotate Image',
        'Lightbox'                      => 'Show Image in Lightbox',
    );
    
    // Default Text Strings for TS Google Maps PLUS
    $this->TS_VCSC_Google_MapPLUS_Language_Defaults = array(
        'ListenersStart'                => 'Start Listeners',
        'ListenersStop'                 => 'Stop Listeners',
        'MobileShow'                    => 'Show Google Map',
        'MobileHide'                    => 'Hide Google Map',
        'StyleDefault'                  => 'Google Standard',
        'StyleLabel'                    => 'Change Map Style',
        'FilterAll'                     => 'All Groups',
        'FilterLabel'                   => 'Filter by Groups',
        'SelectLabel'                   => 'Zoom to Location',
        'ControlsOSM'                   => 'Open Street',
        'ControlsHome'                  => 'Home',
        'ControlsBounds'                => 'Fit All',
        'ControlsBike'                  => 'Bicycle Trails',
        'ControlsTraffic'               => 'Traffic',
        'ControlsTransit'               => 'Transit',
        'TrafficMiles'                  => 'Miles per Hour',
        'TrafficKilometer'              => 'Kilometers per Hour',
        'TrafficNone'                   => 'No Data Available',
        'SearchButton'                  => 'Find New Location',
        'SearchHolder'                  => 'Enter new location to find ...',
        'SearchGoogle'                  => 'View on Google Maps',
        'SearchDirections'              => 'Get Directions',
        'SearchGroup'                   => 'Map Search',
        'OtherLink'                     => 'Learn More!',
        'PlaceholderMarker'             => 'Select Location',
        'ListingsButton'                => 'Search Locations',
        'ListingsSearch'                => 'Enter existing location to search for ...',
		'SumoConfirm'			        => 'Confirm',
		'SumoCancel'			        => 'Cancel',
		'SumoSelected'			        => 'Selected',
		'SumoAllSelected'		        => 'All Selected!',
		'SumoPlaceholder'		        => 'Select Here',
		'SumoSearchLocations'		    => 'Search Locations',
		'SumoSearchGroups'		        => 'Search Groups',
		'SumoSearchStyles'		        => 'Search Styles',
    );
    
    // Default Text Strings for TS Google Maps (Deprecated)
    $this->TS_VCSC_Google_Map_Language_Defaults = array(
        'TextCalcShow'                  => 'Show Address Input',
        'TextCalcHide'                  => 'Hide Address Input',
        'TextDirectionShow'             => 'Show Directions',
        'TextDirectionHide'             => 'Hide Directions',
        'TextResetMap'                  => 'Reset Map',
        'PrintRouteText' 			    => 'Print Route',
        'TextViewOnGoogle'              => 'View on Google',
        'TextButtonCalc'                => 'Show Route',
        'TextSetTarget'                 => 'Please enter your Start Address:',
        'TextGeoLocation'               => 'Get My Location',
        'TextTravelMode'                => 'Travel Mode',
        'TextDriving'                   => 'Driving',
        'TextWalking'                   => 'Walking',
        'TextBicy'                      => 'Bicycling',
        'TextWP'                        => 'Optimize Waypoints',
        'TextButtonAdd'                 => 'Add Stop on the Way',
        'TextDistance'                  => 'Total Distance:',
        'TextMapHome'                   => 'Home',
        'TextMapBikes'                  => 'Bicycle Trails',
        'TextMapTraffic'                => 'Traffic',
        'TextMapSpeedMiles'             => 'Miles Per Hour',
        'TextMapSpeedKM'                => 'Kilometers Per Hour',
        'TextMapNoData'                 => 'No Data Available!',
        'TextMapMiles'                  => 'Miles',
        'TextMapKilometes'              => 'Kilometers',
        'TextMapActivate'               => 'Show Google Map',
        'TextMapDeactivate'             => 'Hide Google Map',
    );
    
    // Default Text Strings for TS Plyr Video Player
    $this->TS_VCSC_Plyr_Player_Language_Defaults = array(
        'restart' 				        => 'Restart',
        'rewind' 				        => 'Rewind {seektime} Secs',
        'play' 				            => 'Play',
        'pause' 				        => 'Pause',
        'forward' 				        => 'Forward {seektime} Secs',
        'played' 				        => 'Played',
        'buffered' 			            => 'Buffered',
        'currenttime' 			        => 'Current Time',
        'duration' 			            => 'Duration',
        'volume' 				        => 'Volume',
        'togglemute' 			        => 'Toggle Mute',
        'togglecaptions' 		        => 'Toggle Captions',
        'togglefullscreen' 	            => 'Toggle Fullscreen',
        'frametitle' 			        => 'Player for {title}',
    );
    
    // Default Text Strings for TS Loan Calculator
    $this->TS_VCSC_Loan_Calculator_Language_Defaults = array(
        // General Text Strings
		'settings_title'				=> 'Enter Loan Information:',
		'settings_results'				=> 'Loan Results (Fixed Term):',
        // Baseline Text Strings
        'baseline_message'				=> 'Select the unknown loan variable you want to determine, based on all other provided loan information:',
        'baseline_payment'				=> 'Payment Amount',
        'baseline_term'					=> 'Amortization Term',
        'baseline_principal'			=> 'Loan Amount',
        // Principal Text Strings
		'principal_label'				=> 'Loan Amount (Principal):',
		'principal_error'				=> 'Please provide a valid value for the loan amount!',
        // Interest Text Strings
		'interest_label'				=> 'Annual Interest Rate (%):',
		'interest_error'				=> 'Please provide a valid value for the interest rate!',
        // Amortization Text Strings
		'years_label'					=> 'Amortization Term in Years:',
		'years_error'					=> 'Please provide a valid value for the desired loan amortization!',
        // Payment Text Strings
		'payment_label'					=> 'Payment Amount:',
		'payment_error'					=> 'Please provide a valid value for the desired payment amount!',
        // Fixed Term Text Strings
		'fixed_label'					=> 'Interest Fixed Term:',
		'fixed_match'					=> 'Match Amortization Term',
        // Frequency Text Strings
        'frequency_label'				=> 'Payment Frequency:',
        // Compounding Text Strings
        'compounding_label'				=> 'Compounding Method:',
        'compounding_simple'			=> 'Simple Interest (No Compounding)',
        'compounding_monthly'			=> 'Monthly Compounding',
        'compounding_quarter'			=> 'Quarterly Compounding',
        'compounding_semi'				=> 'Semi-Annual Compounding',
        'compounding_annual'			=> 'Annual Compounding',	
        // Origination Text Strings
		'origination_label'				=> 'Loan Origination Date:',
		'origination_error'				=> 'Please provide a valid value for the origination date, using the format yyyy-mm-dd!',
        // Disclaimer Text Strings
        'disclaimer_message'            => 'This loan calculator will only provide you with estimates; you will receive the final and accurate loan breakdown from your lender at the time of closing.',
        // Button Text Strings
        'button_calculate'				=> 'Calculate Loan',
        'button_reset'					=> 'Reset Calculator',
        'button_chartshow'				=> 'Show Chart',
        'button_charthide'				=> 'Hide Chart',
        'button_chartsave'				=> 'Save Chart',
        'button_scheduleshow'			=> 'Show Schedule',
        'button_schedulehide'			=> 'Hide Schedule',
        'button_printable'				=> 'Create Printout',
        // Chart Text Strings
        'chart_title'					=> 'Loan Payment Information',
        'chart_interest'				=> 'Total Interest',
        'chart_principal'				=> 'Total Principal',
        'chart_combined'				=> 'Total Payments',
        'chart_balance'					=> 'Loan Balance',
        // Schedule Text Strings
        'schedule_reponsive'		    => 'Table Mode',
        'schedule_stack'			    => 'Stack',
        'schedule_swipe'			    => 'Swipe',
        'schedule_toggle'			    => 'Toggle',
        'schedule_columns'			    => 'Columns',
        'schedule_error'			    => 'No eligible columns.',
        'schedule_sort'			        => 'Sort Columns',		
        // Printable Text Strings
		'printable_title'				=> 'Loan Calculator Results',
		'printable_button'				=> 'Print Page',
        // Global Text Strings
        'single_year'			        => 'Year',
        'single_month'			        => 'Month',
        'single_day'				    => 'Day',
        'plural_year'			        => 'Years',
        'plural_month'			        => 'Months',
        'plural_day'				    => 'Days',
        'not_available'			        => 'N/A',
        'period_weekly'			        => 'Weekly',
        'period_biweekly'		        => 'Bi-Weekly',
        'period_semimonthly'		    => 'Semi-Monthly',
        'period_monthly'			    => 'Monthly',
        'period_quarterly'		        => 'Quarterly',
        'period_semiannually'	        => 'Semi-Annually',
        'period_annually'		        => 'Annually',
        'payment_date'			        => 'Date',
        'payment_interest'		        => 'Interest',
        'payment_principal'		        => 'Principal',
        'payment_balance'		        => 'Remaining Balance',
        'accumulated_principal'	        => 'Accumulated Principal',
        'accumulated_interest'	        => 'Accumulated Interest',
        'accumulated_total'		        => 'Accumulated Total',
        'summary_loanamount'		    => 'Loan Amount:',
        'summary_loanbalance'	        => 'Remaining Loan Balance:',
        'summary_datepayout'		    => 'Loan Payout Date:',
        'summary_datefirst'		        => 'First Payment Date:',
        'summary_datelast'		        => 'Last Payment Date:',
        'summary_paymentfirst'	        => 'First Loan Payment:',
        'summary_paymentlast'	        => 'Last Loan Payment:',
        'summary_amortization'	        => 'Amortization Term:',
        'summary_interest'		        => 'Interest Rate:',
        'summary_frequency'		        => 'Payment Frequency:',
        'summary_compounding'	        => 'Compounding Method:',
        'summary_fixedterm'		        => 'Initial Fixed Term:',
        'summary_fixedpayments'	        => 'Initial Number of Payments:',
        'summary_totalpayments'	        => 'Total Payments Made:',
        'summary_totalinterest'	        => 'Total Interest Paid:',
        'summary_totalprincipal'	    => 'Total Principal Paid:',
        'notice_startdate'		        => 'For dates greater than the 28th of the month, the date will be changed to 28 to simplify calculations.',
        'notice_semimonthly'		    => 'For semi-monthly payments, the payment days will be the 1st and the 16th of each month, and the starting date will be the next 1st or 16th. Interest will be calculated based on 24 equal periods per year, regardless of the actual interval between payments.',
        'notice_insufficient'	        => 'The combination of desired payment amount and interest rate does not cover the first month of interest payments!',
    );
    
    // Define Global Array of Social Networks
    $this->TS_VCSC_Social_Networks_Array = array(
        "Email"                         => array("order" => 0,      "string" => "email",        "link" => "",       "class" => "ts-social-email",           "icon" => "ts-teamicon-email3"),
        "Phone"                         => array("order" => 1,      "string" => "phone",        "link" => "",       "class" => "ts-social-phone",           "icon" => "ts-teamicon-phone2"),
        "Cell"                          => array("order" => 2,      "string" => "cell",         "link" => "",       "class" => "ts-social-cell",            "icon" => "ts-teamicon-mobile"),
        "Portfolio"                     => array("order" => 3,      "string" => "portfolio",    "link" => "",       "class" => "ts-social-portfolio",       "icon" => "ts-teamicon-portfolio"),
        "Link"                          => array("order" => 4,      "string" => "link",         "link" => "",       "class" => "ts-social-link",            "icon" => "ts-teamicon-link"),
        "Behance"                       => array("order" => 5,      "string" => "behance",      "link" => "",       "class" => "ts-social-behance",         "icon" => "ts-teamicon-behance"),
        "Digg"                          => array("order" => 6,      "string" => "digg",         "link" => "",       "class" => "ts-social-digg",            "icon" => "ts-teamicon-digg1"),
        "Dribbble"                      => array("order" => 7,      "string" => "dribbble",     "link" => "",       "class" => "ts-social-dribbble",        "icon" => "ts-teamicon-dribbble1"),
        "Dropbox"                       => array("order" => 8,      "string" => "dropbox",      "link" => "",       "class" => "ts-social-dropbox",         "icon" => "ts-teamicon-dropbox1"),
        "Envato"                        => array("order" => 9,      "string" => "envato",       "link" => "",       "class" => "ts-social-envato",          "icon" => "ts-teamicon-envato"),
        "EverNote"                      => array("order" => 10,     "string" => "evernote",     "link" => "",       "class" => "ts-social-evernote",        "icon" => "ts-teamicon-evernote1"),
        "Facebook"                      => array("order" => 11,     "string" => "facebook",     "link" => "",       "class" => "ts-social-facebook",        "icon" => "ts-teamicon-facebook3"),
        "Flickr"                        => array("order" => 12,     "string" => "flickr",       "link" => "",       "class" => "ts-social-flickr",          "icon" => "ts-teamicon-flickr4"),
        "Github"                        => array("order" => 13,     "string" => "github",       "link" => "",       "class" => "ts-social-github",          "icon" => "ts-teamicon-github3"),
        "Google"                        => array("order" => 14,     "string" => "gplus",        "link" => "",       "class" => "ts-social-gplus",           "icon" => "ts-teamicon-googleplus1"),
        "Instagram"                     => array("order" => 15,     "string" => "instagram",    "link" => "",       "class" => "ts-social-instagram",       "icon" => "ts-teamicon-instagram"),
        "LastFM"                        => array("order" => 16,     "string" => "lastfm",       "link" => "",       "class" => "ts-social-lastfm",          "icon" => "ts-teamicon-lastfm2"),
        "LinkedIn"                      => array("order" => 17,     "string" => "linkedin",     "link" => "",       "class" => "ts-social-linkedin",        "icon" => "ts-teamicon-linkedin1"),
        "Paypal"                        => array("order" => 18,     "string" => "paypal",       "link" => "",       "class" => "ts-social-paypal",          "icon" => "ts-teamicon-paypal1"),
        "Picasa"                        => array("order" => 19,     "string" => "picasa",       "link" => "",       "class" => "ts-social-picasa",          "icon" => "ts-teamicon-picasa1"),
        "Pinterest"                     => array("order" => 20,     "string" => "pinterest",    "link" => "",       "class" => "ts-social-pinterest",       "icon" => "ts-teamicon-pinterest1"),
        "RSS"                           => array("order" => 21,     "string" => "rss",          "link" => "",       "class" => "ts-social-rss",             "icon" => "ts-teamicon-rss1"),
        "Skype"                         => array("order" => 22,     "string" => "skype",        "link" => "",       "class" => "ts-social-skype",           "icon" => "ts-teamicon-skype"),
        "Soundcloud"                    => array("order" => 23,     "string" => "soundcloud",   "link" => "",       "class" => "ts-social-soundcloud",      "icon" => "ts-teamicon-soundcloud"),
        "Spotify"                       => array("order" => 24,     "string" => "spotify",      "link" => "",       "class" => "ts-social-spotify",         "icon" => "ts-teamicon-spotify2"),
        "StumbleUpon"                   => array("order" => 25,     "string" => "stumbleupon",  "link" => "",       "class" => "ts-social-stumbleupon",     "icon" => "ts-teamicon-stumbleupon2"),
        "Twitter"                       => array("order" => 26,     "string" => "twitter",      "link" => "",       "class" => "ts-social-twitter",         "icon" => "ts-teamicon-twitter4"),
        "Tumblr"                        => array("order" => 27,     "string" => "tumblr",       "link" => "",       "class" => "ts-social-tumblr",          "icon" => "ts-teamicon-tumblr4"),
        "Vimeo"                         => array("order" => 28,     "string" => "vimeo",        "link" => "",       "class" => "ts-social-vimeo",           "icon" => "ts-teamicon-vimeo1"),
        "VKontakte"                     => array("order" => 29,     "string" => "vkontakte",    "link" => "",       "class" => "ts-social-vkontakte",       "icon" => "ts-teamicon-vkontakte"),
        "Wikipedia"                     => array("order" => 30,     "string" => "wikipedia",    "link" => "",       "class" => "ts-social-wikipedia",       "icon" => "ts-teamicon-wikipedia"),
        "Xing"                          => array("order" => 31,     "string" => "xing",         "link" => "",       "class" => "ts-social-xing",            "icon" => "ts-teamicon-xing3"),
        "YouTube"                       => array("order" => 32,     "string" => "youtube",      "link" => "",       "class" => "ts-social-youtube",         "icon" => "ts-teamicon-youtube4"),
    );
    
    // Array with Date/Time Icons
    $this->TS_VCSC_TimelineDateTimeCompliant = array(
        array("dashicons-clock"                     => "clock"),
        array("dashicons-calendar"                  => "calendar"),
        array("dashicons-info"                      => "info"),
        array("dashicons-location"                  => "location"),
        array("dashicons-heart"                     => "heart"),
        array("dashicons-megaphone"                 => "megaphone"),
        array("dashicons-art"                       => "art"),
    );
    
    // Array with Button Icons
    $this->TS_VCSC_TimelineButtonCompliant = array(
        array("dashicons-visibility"                => "eye"),
        array("dashicons-info"                      => "info"),
        array("dashicons-admin-links"               => "link"),
        array("dashicons-search"                    => "search"),
        array("dashicons-lightbulb"                 => "lightbulb"),
        array("dashicons-admin-network"             => "key"),
        array("dashicons-book"                      => "book"),
        array("dashicons-awards"                    => "award"),
    );

    // Array with Team Icons 1
    $this->TS_VCSC_TeamBusinessCompliant = array(
        array("ts-teamicon-clock1 ts-font-icon"     => "clock1"),
        array("ts-teamicon-calendar1 ts-font-icon"  => "calendar1"),
        array("ts-teamicon-info1 ts-font-icon"      => "info1"),
        array("ts-teamicon-location1 ts-font-icon"  => "location1"),
    );

    // Array with Team Icons 2
    $this->TS_VCSC_TeamButtonCompliant = array(
        array("ts-teamicon-eye2 ts-font-icon"       => "eye2"),
        array("ts-teamicon-eye5 ts-font-icon"       => "eye5"),
        array("ts-teamicon-eye1 ts-font-icon"       => "eye1"),
        array("ts-teamicon-eye3 ts-font-icon"       => "eye3"),
        array("ts-teamicon-info1 ts-font-icon"      => "info1"),
        array("ts-teamicon-info4 ts-font-icon"      => "info4"),
        array("ts-teamicon-link ts-font-icon"       => "link"),
        array("ts-teamicon-link5 ts-font-icon"      => "link5"),
    );

    // Array with Team Icons 3
    $this->TS_VCSC_TeamAttachmentCompliant = array(
        array("ts-teamicon-download3 ts-font-icon"  => "download3"),
        array("ts-teamicon-download4 ts-font-icon"  => "download4"),
        array("ts-teamicon-download5 ts-font-icon"  => "eyedownload51"),
        array("ts-teamicon-download7 ts-font-icon"  => "download7"),
        array("ts-teamicon-file4 ts-font-icon"      => "file4"),
        array("ts-teamicon-file14 ts-font-icon"     => "file14"),
        array("ts-teamicon-link ts-font-icon"       => "link"),
        array("ts-teamicon-link5 ts-font-icon"      => "link5"),
    );
    
    // Array with Rating Icons
    $this->TS_VCSC_RatingScaleIconsCompliant = array(
        array('ts-ecommerce-starfull1'			    => 'star'),
        array('ts-ecommerce-starfull2'			    => 'star'),
        array('ts-ecommerce-starfull3'			    => 'star'),
        array('ts-ecommerce-starfull4'			    => 'star'),
        array('ts-ecommerce-heartfull'			    => 'heart'),
        array('ts-ecommerce-heart'				    => 'heart'),
        array('ts-ecommerce-thumbsup'			    => 'thumbs'),
        array('ts-ecommerce-ribbon4'			    => 'ribbon'),
    );
    
    // Array with Navigator Icons
    $this->TS_VCSC_NavigatorIconsCompliant = array(
        "Page Navigator Icon Selection" => array(
            array('dashicons-arrow-up-alt'          => 'arrow up alt'),
            array('dashicons-arrow-up'              => 'arrow up'),
            array('dashicons-arrow-up-alt2'         => 'arrow up alt 2'),
            array('dashicons-menu'                  => 'menu'),
            array('dashicons-admin-home'			=> 'home'),
            array('dashicons-admin-site'            => 'globe'),
            array('dashicons-heart'                 => 'heart'),
            array('dashicons-star-filled'			=> 'star filled'),
            array('dashicons-star-empty'			=> 'star empty'),
            array('dashicons-smiley'			    => 'miley'),
        ),
    );
    
    // Array with Hover Effects Icons
    $this->TS_VCSC_HoverEffectsIconsSelectionCompliant = array(
        "Hover Effects Icon Selection" => array(
            array("ts-teamicon-500px"               => "500px"),
            array("ts-teamicon-android"             => "android"),
            array("ts-teamicon-apple"               => "apple"),
            array("ts-teamicon-apple2"              => "apple"),
            array("ts-teamicon-barcode"             => "barcode"),
            array("ts-teamicon-bebo"                => "bebo"),
            array("ts-teamicon-behance"             => "behance"),
            array("ts-teamicon-bitbucket"           => "bitbucket"),
            array("ts-teamicon-blogger"             => "blogger"),
            array("ts-teamicon-blogger1"            => "blogger"),
            array("ts-teamicon-blogger2"            => "blogger"),
            array("ts-teamicon-bubble"              => "bubble"),
            array("ts-teamicon-bubble2"             => "bubble"),
            array("ts-teamicon-bubbles2"            => "bubble"),
            array("ts-teamicon-bubbles3"            => "bubble"),
            array("ts-teamicon-bubbles4"            => "bubble"),
            array("ts-teamicon-bubbles"             => "bubble"),
            array("ts-teamicon-buffer"              => "buffer"),
            array("ts-teamicon-calendar1"           => "calendar"),
            array("ts-teamicon-calendar2"           => "calendar"),
            array("ts-teamicon-calendar3"           => "calendar"),
            array("ts-teamicon-calendar4"           => "calendar"),
            array("ts-teamicon-calendar5"           => "calendar"),
            array("ts-teamicon-calendar6"           => "calendar"),
            array("ts-teamicon-calendar7"           => "calendar"),
            array("ts-teamicon-calendar8"           => "calendar"),
            array("ts-teamicon-calendar9"           => "calendar"),
            array("ts-teamicon-calendar10"          => "e640"),
            array("ts-teamicon-chimein"             => "chimein"),
            array("ts-teamicon-chrome"              => "chrome"),
            array("ts-teamicon-clock1"              => "clock"),
            array("ts-teamicon-clock2"              => "clock"),
            array("ts-teamicon-clock3"              => "clock"),
            array("ts-teamicon-clock4"              => "clock"),
            array("ts-teamicon-clock5"              => "clock"),
            array("ts-teamicon-clock6"              => "clock"),
            array("ts-teamicon-clock7"              => "clock"),
            array("ts-teamicon-clock8"              => "clock"),
            array("ts-teamicon-coderwall"           => "coderwall"),
            array("ts-teamicon-cog"                 => "cog"),
            array("ts-teamicon-cog2"                => "cog"),
            array("ts-teamicon-cogs"                => "cogs"),
            array("ts-teamicon-dailymotion"         => "dailymotion"),
            array("ts-teamicon-delicious"           => "delicious"),
            array("ts-teamicon-delicious2"          => "delicious"),
            array("ts-teamicon-deviantart"          => "deviantart"),
            array("ts-teamicon-deviantart1"         => "deviantart"),
            array("ts-teamicon-deviantart2"         => "deviantart"),
            array("ts-teamicon-digg1"               => "digg"),
            array("ts-teamicon-disqus"              => "disqus"),
            array("ts-teamicon-download1"           => "download"),
            array("ts-teamicon-download2"           => "download"),
            array("ts-teamicon-download3"           => "download"),
            array("ts-teamicon-download4"           => "download"),
            array("ts-teamicon-download5"           => "download"),
            array("ts-teamicon-download6"           => "download"),
            array("ts-teamicon-download7"           => "download"),
            array("ts-teamicon-download8"           => "download"),
            array("ts-teamicon-dribbble1"           => "dribble"),
            array("ts-teamicon-dribbble3"           => "dribble"),
            array("ts-teamicon-dropbox1"            => "dropbox"),
            array("ts-teamicon-dropbox2"            => "dropbox"),
            array("ts-teamicon-easid"               => "easid"),
            array("ts-teamicon-email1"              => "email"),
            array("ts-teamicon-email2"              => "email"),
            array("ts-teamicon-email3"              => "email"),
            array("ts-teamicon-email4"              => "email"),
            array("ts-teamicon-email5"              => "email"),
            array("ts-teamicon-email6"              => "email"),
            array("ts-teamicon-email7"              => "email"),
            array("ts-teamicon-email8"              => "email"),
            array("ts-teamicon-email9"              => "email"),
            array("ts-teamicon-email10"             => "email"),
            array("ts-teamicon-envato"              => "envato"),
            array("ts-teamicon-equalizer"           => "equalizer"),
            array("ts-teamicon-evernote1"           => "evernote"),
            array("ts-teamicon-evernote2"           => "evernote"),
            array("ts-teamicon-eye1"                => "eye"),
            array("ts-teamicon-eye2"                => "eye"),
            array("ts-teamicon-eye3"                => "eye"),
            array("ts-teamicon-eye4"                => "eye"),
            array("ts-teamicon-eye5"                => "eye"),
            array("ts-teamicon-facebook1"           => "facebook"),
            array("ts-teamicon-facebook2"           => "facebook"),
            array("ts-teamicon-facebook3"           => "facebook"),
            array("ts-teamicon-facebook4"           => "facebook"),
            array("ts-teamicon-fax1"                => "fax"),
            array("ts-teamicon-fax2"                => "fax"),
            array("ts-teamicon-feedburner"          => "feedburner"),
            array("ts-teamicon-file1"               => "file"),
            array("ts-teamicon-file2"               => "file"),
            array("ts-teamicon-file3"               => "file"),
            array("ts-teamicon-file4"               => "file"),
            array("ts-teamicon-file5"               => "file"),
            array("ts-teamicon-file6"               => "file"),
            array("ts-teamicon-file7"               => "file"),
            array("ts-teamicon-file8"               => "file"),
            array("ts-teamicon-file9"               => "file"),
            array("ts-teamicon-file10"              => "file"),
            array("ts-teamicon-file11"              => "file"),
            array("ts-teamicon-file12"              => "file"),
            array("ts-teamicon-file13"              => "file"),
            array("ts-teamicon-file14"              => "file"),
            array("ts-teamicon-file15"              => "file"),
            array("ts-teamicon-file16"              => "file"),
            array("ts-teamicon-file17"              => "file"),
            array("ts-teamicon-file18"              => "file"),
            array("ts-teamicon-file19"              => "file"),
            array("ts-teamicon-finder"              => "finder"),
            array("ts-teamicon-flattr"              => "flattr"),
            array("ts-teamicon-flattr2"             => "flattr"),
            array("ts-teamicon-flickr1"             => "flickr"),
            array("ts-teamicon-flickr2"             => "flickr"),
            array("ts-teamicon-flickr3"             => "flickr"),
            array("ts-teamicon-flickr4"             => "flickr"),
            array("ts-teamicon-forrst"              => "forrst"),
            array("ts-teamicon-forrst1"             => "forrst"),
            array("ts-teamicon-forrst2"             => "forrst"),
            array("ts-teamicon-foursquare"          => "foursquare"),
            array("ts-teamicon-foursquare1"         => "foursquare"),
            array("ts-teamicon-foursquare2"         => "foursquare"),
            array("ts-teamicon-foursquare3"         => "foursquare"),
            array("ts-teamicon-friendfeed"          => "friendfeed"),
            array("ts-teamicon-github1"             => "github"),
            array("ts-teamicon-github2"             => "github"),
            array("ts-teamicon-github3"             => "github"),
            array("ts-teamicon-github4"             => "github"),
            array("ts-teamicon-github5"             => "github"),
            array("ts-teamicon-google"              => "goolge"),
            array("ts-teamicon-google-plus-sign"    => "googleplus"),
            array("ts-teamicon-googledrive"         => "googledrive"),
            array("ts-teamicon-googleplus1"         => "googleplus"),
            array("ts-teamicon-googleplus2"         => "googleplus"),
            array("ts-teamicon-googleplus3"         => "googleplus"),
            array("ts-teamicon-grooveshark"         => "grooveshark"),
            array("ts-teamicon-habrahabr"           => "habrahabr"),
            array("ts-teamicon-heart"               => "heart"),
            array("ts-teamicon-heart2"              => "heart"),
            array("ts-teamicon-heart-broken"        => "heart"),
            array("ts-teamicon-home2"               => "home"),
            array("ts-teamicon-home3"               => "home"),
            array("ts-teamicon-home"                => "home"),
            array("ts-teamicon-identica"            => "identica"),
            array("ts-teamicon-info1"               => "info"),
            array("ts-teamicon-info2"               => "info"),
            array("ts-teamicon-info3"               => "info"),
            array("ts-teamicon-info4"               => "info"),
            array("ts-teamicon-instagram"           => "instagram"),
            array("ts-teamicon-instagram2"          => "instagram"),
            array("ts-teamicon-jabber"              => "jabber"),
            array("ts-teamicon-joomla"              => "joomla"),
            array("ts-teamicon-lanyrd"              => "lanyrd"),
            array("ts-teamicon-lanyrd2"             => "lanyrd"),
            array("ts-teamicon-lastfm1"             => "lastfm"),
            array("ts-teamicon-lastfm2"             => "lastfm"),
            array("ts-teamicon-lastfm3"             => "lastfm"),
            array("ts-teamicon-link"                => "link"),
            array("ts-teamicon-link2"               => "link"),
            array("ts-teamicon-link3"               => "link"),
            array("ts-teamicon-link4"               => "link"),
            array("ts-teamicon-link5"               => "link"),
            array("ts-teamicon-link6"               => "link"),
            array("ts-teamicon-link7"               => "link"),
            array("ts-teamicon-link8"               => "link"),
            array("ts-teamicon-linkedin"            => "linkedin"),
            array("ts-teamicon-linkedin1"           => "linkedin"),
            array("ts-teamicon-linkedin2"           => "linkedin"),
            array("ts-teamicon-location1"           => "location"),
            array("ts-teamicon-location2"           => "location"),
            array("ts-teamicon-mobile"              => "mobile"),
            array("ts-teamicon-moikrug"             => "moikrug"),
            array("ts-teamicon-myspace2"            => "myspace"),
            array("ts-teamicon-myspace"             => "myspace"),
            array("ts-teamicon-netcodes"            => "netcodes"),
            array("ts-teamicon-newsvine"            => "newsvine"),
            array("ts-teamicon-office"              => "office"),
            array("ts-teamicon-outlook"             => "outlook"),
            array("ts-teamicon-paypal1"             => "paypal"),
            array("ts-teamicon-paypal2"             => "paypal"),
            array("ts-teamicon-paypal3"             => "paypal"),
            array("ts-teamicon-phone1"              => "e6e6"),
            array("ts-teamicon-phone2"              => "phone"),
            array("ts-teamicon-phone3"              => "phone"),
            array("ts-teamicon-picasa1"             => "picasa"),
            array("ts-teamicon-picasa2"             => "picasa"),
            array("ts-teamicon-pinterest1"          => "pinterest"),
            array("ts-teamicon-pinterest2"          => "pinterest"),
            array("ts-teamicon-pinterest3"          => "pinterest"),
            array("ts-teamicon-pinterest-sign"      => "pinterest"),
            array("ts-teamicon-playstore"           => "playstore"),
            array("ts-teamicon-pocket"              => "pocket"),
            array("ts-teamicon-portfolio"           => "portfolio"),
            array("ts-teamicon-qrcode"              => "qrcode"),
            array("ts-teamicon-readability"         => "readability"),
            array("ts-teamicon-reddit"              => "reddit"),
            array("ts-teamicon-reddit2"             => "reddit"),
            array("ts-teamicon-rss1"                => "rss"),
            array("ts-teamicon-rss2"                => "rss"),
            array("ts-teamicon-settings"            => "settings"),
            array("ts-teamicon-skype"               => "skype"),
            array("ts-teamicon-skype2"              => "skype"),
            array("ts-teamicon-slideshare"          => "slideshare"),
            array("ts-teamicon-soundcloud"          => "soundcloud"),
            array("ts-teamicon-soundcloud2"         => "soundcloud"),
            array("ts-teamicon-spotify1"            => "spotify"),
            array("ts-teamicon-spotify2"            => "spotify"),
            array("ts-teamicon-spotify3"            => "spotify"),
            array("ts-teamicon-stackoverflow"       => "stackoverflow"),
            array("ts-teamicon-star"                => "star"),
            array("ts-teamicon-star2"               => "star"),
            array("ts-teamicon-star3"               => "star"),
            array("ts-teamicon-steam"               => "steam"),
            array("ts-teamicon-steam1"              => "steam"),
            array("ts-teamicon-steam2"              => "steam"),
            array("ts-teamicon-stumbleupon1"        => "stumbleupon"),
            array("ts-teamicon-stumbleupon2"        => "stumbleupon"),
            array("ts-teamicon-tag"                 => "tag"),
            array("ts-teamicon-tags"                => "tags"),
            array("ts-teamicon-thumbs-up2"          => "thumb"),
            array("ts-teamicon-thumbs-up"           => "thumb"),
            array("ts-teamicon-tripadvisor"         => "tripadvisor"),
            array("ts-teamicon-tumblr1"             => "tumblr"),
            array("ts-teamicon-tumblr2"             => "tumblr"),
            array("ts-teamicon-tumblr3"             => "tumblr"),
            array("ts-teamicon-tumblr4"             => "tumblr"),
            array("ts-teamicon-tux"                 => "tux"),
            array("ts-teamicon-twitter1"            => "twitter"),
            array("ts-teamicon-twitter2"            => "twitter"),
            array("ts-teamicon-twitter3"            => "twitter"),
            array("ts-teamicon-twitter4"            => "twitter"),
            array("ts-teamicon-user"                => "user"),
            array("ts-teamicon-user2"               => "user"),
            array("ts-teamicon-user3"               => "user"),
            array("ts-teamicon-user4"               => "user"),
            array("ts-teamicon-users"               => "users"),
            array("ts-teamicon-users2"              => "users"),
            array("ts-teamicon-viadeo"              => "viadeo"),
            array("ts-teamicon-vimeo1"              => "vimeo"),
            array("ts-teamicon-vimeo2"              => "vimeo"),
            array("ts-teamicon-vimeo3"              => "vimeo"),
            array("ts-teamicon-vimeo4"              => "vimeo"),
            array("ts-teamicon-vine"                => "vine"),
            array("ts-teamicon-vkontakte"           => "vkontakte"),
            array("ts-teamicon-wikipedia"           => "wikipedia"),
            array("ts-teamicon-windows"             => "windows"),
            array("ts-teamicon-windows2"            => "windows"),
            array("ts-teamicon-windows8"            => "windows"),
            array("ts-teamicon-wordpress"           => "wordpress"),
            array("ts-teamicon-wordpress1"          => "wordpress"),
            array("ts-teamicon-wordpress2"          => "wordpress"),
            array("ts-teamicon-wrench"              => "wrench"),
            array("ts-teamicon-xbox"                => "xbox"),
            array("ts-teamicon-xing1"               => "xing"),
            array("ts-teamicon-xing2"               => "xing"),
            array("ts-teamicon-xing3"               => "xing"),
            array("ts-teamicon-xing4"               => "xing"),
            array("ts-teamicon-yahoo"               => "yahoo"),
            array("ts-teamicon-yahoo2"              => "yahoo"),
            array("ts-teamicon-yandex"              => "yandex"),
            array("ts-teamicon-yelp"                => "yelp"),
            array("ts-teamicon-yelp2"               => "yelp"),
            array("ts-teamicon-youtube1"            => "youtube"),
            array("ts-teamicon-youtube2"            => "youtube"),
            array("ts-teamicon-youtube3"            => "youtube"),
            array("ts-teamicon-youtube4"            => "youtube"),
            array("ts-teamicon-zerply"              => "zerply"),
            array("ts-teamicon-zynga"               => "zynga"),
        ),
    );
    
    // Preloader Selection
    $this->TS_VCSC_Preloader_Styles = array(
        "Preloader #0"				                            => "0",        
        "Preloader #1"			                                => "1",
        "Preloader #2"			                                => "2",
        "Preloader #3"			                                => "3",
        "Preloader #4"                                          => "4",
        "Preloader #5"                                          => "5",
        "Preloader #6"                                          => "6",
        "Preloader #7"                                          => "7",
        "Preloader #8"                                          => "8",
        "Preloader #9"                                          => "9",
        "Preloader #10"                                         => "10",
        "Preloader #11"                                         => "11",
        "Preloader #12"                                         => "12",
        "Preloader #13"                                         => "13",
        "Preloader #14"                                         => "14",
        "Preloader #15"                                         => "15",
        "Preloader #16"                                         => "16",
        "Preloader #17"                                         => "17",
        "Preloader #18"                                         => "18",
        "Preloader #19"                                         => "19",
        "Preloader #20"                                         => "20",
        "Preloader #21"                                         => "21",
        "Preloader #22"                                         => "22",
        __("No Preloader", "ts_visual_composer_extend")         => "-1",
    );
    
    // Google GeoMap Chart Options
    $this->TS_VCSC_GeoMap_Regions = array(
        "World"                                                 => "world",
        "Continent: Africa"                                     => "002",
        "Continent: Europe"                                     => "150",
        "Continent: Americas"                                   => "019",
        "Continent: Asia"                                       => "142",
        "Continent: Oceania"                                    => "009",
        "Sub-Continent: Africa - Northern"                      => "015",
        "Sub-Continent: Africa - Western"                       => "011",
        "Sub-Continent: Africa - Middle"                        => "017",
        "Sub-Continent: Africa - Eastern"                       => "014",
        "Sub-Continent: Africa - Southern"                      => "018",
        "Sub-Continent: Europe - Northern"                      => "154",
        "Sub-Continent: Europe - Western"                       => "155",
        "Sub-Continent: Europe - Eastern"                       => "151",
        "Sub-Continent: Europe - Southern"                      => "039",
        "Sub-Continent: Americas - Northern"                    => "021",
        "Sub-Continent: Americas - Caribbean"                   => "029",
        "Sub-Continent: Americas - Central"                     => "013",
        "Sub-Continent: Americas - South"                       => "005",
        "Sub-Continent: Asia - Central"                         => "143",
        "Sub-Continent: Asia - Eastern"                         => "030",
        "Sub-Continent: Asia - Southern"                        => "034",
        "Sub-Continent: Asia - Southern-Eastern"                => "035",
        "Sub-Continent: Asia - Western"                         => "145",
        "Sub-Continent: Oceania - Australia and New Zealand"    => "053",
        "Sub-Continent: Oceania - Melanesia"                    => "054",
        "Sub-Continent: Oceania - Micronesia"                   => "057",
        "Sub-Continent: Oceania - Polynesia"                    => "061",
        "Country: Afghanistan"                                  => "AF",
        "Country: Aland Islands"                                => "AX",
        "Country: Albania"                                      => "AL",
        "Country: Algeria"                                      => "DZ",
        "Country: American Samoa"                               => "AS",
        "Country: Andorra"                                      => "AD",
        "Country: Angola"                                       => "AO",
        "Country: Anguilla"                                     => "AI",
        "Country: Antarctica"                                   => "AQ",
        "Country: Antigua and Barbuda"                          => "AG",
        "Country: Argentina"                                    => "AR",
        "Country: Armenia"                                      => "AM",
        "Country: Aruba"                                        => "AW",
        "Country: Australia"                                    => "AU",
        "Country: Austria"                                      => "AT",
        "Country: Azerbaijan"                                   => "AZ",
        "Country: Bahamas"                                      => "BS",
        "Country: Bahrain"                                      => "BH",
        "Country: Bangladesh"                                   => "BD",
        "Country: Barbados"                                     => "BB",
        "Country: Belarus"                                      => "BY",
        "Country: Belgium"                                      => "BE",
        "Country: Belize"                                       => "BZ",
        "Country: Benin"                                        => "BJ",
        "Country: Bermuda"                                      => "BM",
        "Country: Bhutan"                                       => "BT",
        "Country: Bolivia, Plurinational State of"              => "BO",
        "Country: Bonaire, Sint Eustatius and Saba"             => "BQ",
        "Country: Bosnia and Herzegovina"                       => "BA",
        "Country: Botswana"                                     => "BW",
        "Country: Bouvet Island"                                => "BV",
        "Country: Brazil"                                       => "BR",
        "Country: British Indian Ocean Territory"               => "IO",
        "Country: Brunei Darussalam"                            => "BN",
        "Country: Bulgaria"                                     => "BG",
        "Country: Burkina Faso"                                 => "BF",
        "Country: Burundi"                                      => "BI",
        "Country: Cambodia"                                     => "KH",
        "Country: Cameroon"                                     => "CM",
        "Country: Canada"                                       => "CA",
        "Country: Cape Verde"                                   => "CV",
        "Country: Cayman Islands"                               => "KY",
        "Country: Central African Republic"                     => "CF",
        "Country: Chad"                                         => "TD",
        "Country: Chile"                                        => "CL",
        "Country: China"                                        => "CN",
        "Country: Christmas Island"                             => "CX",
        "Country: Cocos (Keeling) Islands"                      => "CC",
        "Country: Colombia"                                     => "CO",
        "Country: Comoros"                                      => "KM",
        "Country: Congo"                                        => "CG",
        "Country: Congo, the Democratic Republic of the"        => "CD",
        "Country: Cook Islands"                                 => "CK",
        "Country: Costa Rica"                                   => "CR",
        "Country: Cote d'Ivoire"                                => "CI",
        "Country: Croatia"                                      => "HR",
        "Country: Cuba"                                         => "CU",
        "Country: Curacao"                                      => "CW",
        "Country: Cyprus"                                       => "CY",
        "Country: Czech Republic"                               => "CZ",
        "Country: Denmark"                                      => "DK",
        "Country: Djibouti"                                     => "DJ",
        "Country: Dominica"                                     => "DM",
        "Country: Dominican Republic"                           => "DO",
        "Country: Ecuador"                                      => "EC",
        "Country: Egypt"                                        => "EG",
        "Country: El Salvador"                                  => "SV",
        "Country: Equatorial Guinea"                            => "GQ",
        "Country: Eritrea"                                      => "ER",
        "Country: Estonia"                                      => "EE",
        "Country: Ethiopia"                                     => "ET",
        "Country: Falkland Islands (Malvinas)"                  => "FK",
        "Country: Faroe Islands"                                => "FO",
        "Country: Fiji"                                         => "FJ",
        "Country: Finland"                                      => "FI",
        "Country: France"                                       => "FR",
        "Country: French Guiana"                                => "GF",
        "Country: French Polynesia"                             => "PF",
        "Country: French Southern Territories"                  => "TF",
        "Country: Gabon"                                        => "GA",
        "Country: Gambia"                                       => "GM",
        "Country: Georgia"                                      => "GE",
        "Country: Germany"                                      => "DE",
        "Country: Ghana"                                        => "GH",
        "Country: Gibraltar"                                    => "GI",
        "Country: Greece"                                       => "GR",
        "Country: Greenland"                                    => "GL",
        "Country: Grenada"                                      => "GD",
        "Country: Guadeloupe"                                   => "GP",
        "Country: Guam"                                         => "GU",
        "Country: Guatemala"                                    => "GT",
        "Country: Guernsey"                                     => "GG",
        "Country: Guinea"                                       => "GN",
        "Country: Guinea-Bissau"                                => "GW",
        "Country: Guyana"                                       => "GY",
        "Country: Haiti"                                        => "HT",
        "Country: Heard Island and McDonald Islands"            => "HM",
        "Country: Holy See (Vatican City State)"                => "VA",
        "Country: Honduras"                                     => "HN",
        "Country: Hong Kong"                                    => "HK",
        "Country: Hungary"                                      => "HU",
        "Country: Iceland"                                      => "IS",
        "Country: India"                                        => "IN",
        "Country: Indonesia"                                    => "ID",
        "Country: Iran, Islamic Republic of"                    => "IR",
        "Country: Iraq"                                         => "IQ",
        "Country: Ireland"                                      => "IE",
        "Country: Isle of Man"                                  => "IM",
        "Country: Israel"                                       => "IL",
        "Country: Italy"                                        => "IT",
        "Country: Jamaica"                                      => "JM",
        "Country: Japan"                                        => "JP",
        "Country: Jersey"                                       => "JE",
        "Country: Jordan"                                       => "JO",
        "Country: Kazakhstan"                                   => "KZ",
        "Country: Kenya"                                        => "KE",
        "Country: Kiribati"                                     => "KI",
        "Country: Korea, Democratic People's Republic of"       => "KP",
        "Country: Korea, Republic of"                           => "KR",
        "Country: Kuwait"                                       => "KW",
        "Country: Kyrgyzstan"                                   => "KG",
        "Country: Lao People's Democratic Republic"             => "LA",
        "Country: Latvia"                                       => "LV",
        "Country: Lebanon"                                      => "LB",
        "Country: Lesotho"                                      => "LS",
        "Country: Liberia"                                      => "LR",
        "Country: Libya"                                        => "LY",
        "Country: Liechtenstein"                                => "LI",
        "Country: Lithuania"                                    => "LT",
        "Country: Luxembourg"                                   => "LU",
        "Country: Macao"                                        => "MO",
        "Country: Macedonia, the former Yugoslav Republic of"   => "MK",
        "Country: Madagascar"                                   => "MG",
        "Country: Malawi"                                       => "MW",
        "Country: Malaysia"                                     => "MY",
        "Country: Maldives"                                     => "MV",
        "Country: Mali"                                         => "ML",
        "Country: Malta"                                        => "MT",
        "Country: Marshall Islands"                             => "MH",
        "Country: Martinique"                                   => "MQ",
        "Country: Mauritania"                                   => "MR",
        "Country: Mauritius"                                    => "MU",
        "Country: Mayotte"                                      => "YT",
        "Country: Mexico"                                       => "MX",
        "Country: Micronesia, Federated States of"              => "FM",
        "Country: Moldova, Republic of"                         => "MD",
        "Country: Monaco"                                       => "MC",
        "Country: Mongolia"                                     => "MN",
        "Country: Montenegro"                                   => "ME",
        "Country: Montserrat"                                   => "MS",
        "Country: Morocco"                                      => "MA",
        "Country: Mozambique"                                   => "MZ",
        "Country: Myanmar"                                      => "MM",
        "Country: Namibia"                                      => "NA",
        "Country: Nauru"                                        => "NR",
        "Country: Nepal"                                        => "NP",
        "Country: Netherlands"                                  => "NL",
        "Country: New Caledonia"                                => "NC",
        "Country: New Zealand"                                  => "NZ",
        "Country: Nicaragua"                                    => "NI",
        "Country: Niger"                                        => "NE",
        "Country: Nigeria"                                      => "NG",
        "Country: Niue"                                         => "NU",
        "Country: Norfolk Island"                               => "NF",
        "Country: Northern Mariana Islands"                     => "MP",
        "Country: Norway"                                       => "NO",
        "Country: Oman"                                         => "OM",
        "Country: Pakistan"                                     => "PK",
        "Country: Palau"                                        => "PW",
        "Country: Palestine, State of"                          => "PS",
        "Country: Panama"                                       => "PA",
        "Country: Papua New Guinea"                             => "PG",
        "Country: Paraguay"                                     => "PY",
        "Country: Peru"                                         => "PE",
        "Country: Philippines"                                  => "PH",
        "Country: Pitcairn"                                     => "PN",
        "Country: Poland"                                       => "PL",
        "Country: Portugal"                                     => "PT",
        "Country: Puerto Rico"                                  => "PR",
        "Country: Qatar"                                        => "QA",
        "Country: Reunion"                                      => "RE",
        "Country: Romania"                                      => "RO",
        "Country: Russian Federation"                           => "RU",
        "Country: Rwanda"                                       => "RW",
        "Country: Saint Barthelemy"                             => "BL",
        "Country: Saint Helena, Ascension and Tristan da Cunha" => "SH",
        "Country: Saint Kitts and Nevis"                        => "KN",
        "Country: Saint Lucia"                                  => "LC",
        "Country: Saint Martin (French Part)"                   => "MF",
        "Country: Saint Pierre and Miquelon"                    => "PM",
        "Country: Saint Vincent and the Grenadines"             => "VC",
        "Country: Samoa"                                        => "WS",
        "Country: San Marino"                                   => "SM",
        "Country: Sao Tome and Principe"                        => "ST",
        "Country: Saudi Arabia"                                 => "SA",
        "Country: Senegal"                                      => "SN",
        "Country: Serbia"                                       => "RS",
        "Country: Seychelles"                                   => "SC",
        "Country: Sierra Leone"                                 => "SL",
        "Country: Singapore"                                    => "SG",
        "Country: Sint Maarten (Dutch part)"                    => "SX",
        "Country: Slovakia"                                     => "SK",
        "Country: Slovenia"                                     => "SI",
        "Country: Solomon Islands"                              => "SB",
        "Country: Somalia"                                      => "SO",
        "Country: South Africa"                                 => "ZA",
        "Country: South Georgia and the South Sandwich Islands" => "GS",
        "Country: South Sudan"                                  => "SS",
        "Country: Spain"                                        => "ES",
        "Country: Sri Lanka"                                    => "LK",
        "Country: Sudan"                                        => "SD",
        "Country: Suriname"                                     => "SR",
        "Country: Svalbard and Jan Mayen"                       => "SJ",
        "Country: Swaziland"                                    => "SZ",
        "Country: Sweden"                                       => "SE",
        "Country: Switzerland"                                  => "CH",
        "Country: Syrian Arab Republic"                         => "SY",
        "Country: Taiwan, Province of China"                    => "TW",
        "Country: Tajikistan"                                   => "TJ",
        "Country: Tanzania, United Republic of"                 => "TZ",
        "Country: Thailand"                                     => "TH",
        "Country: Timor-Leste"                                  => "TL",
        "Country: Togo"                                         => "TG",
        "Country: Tokelau"                                      => "TK",
        "Country: Tonga"                                        => "TO",
        "Country: Trinidad and Tobago"                          => "TT",
        "Country: Tunisia"                                      => "TN",
        "Country: Turkey"                                       => "TR",
        "Country: Turkmenistan"                                 => "TM",
        "Country: Turks and Caicos Islands"                     => "TC",
        "Country: Tuvalu"                                       => "TV",
        "Country: Uganda"                                       => "UG",
        "Country: Ukraine"                                      => "UA",
        "Country: United Arab Emirates"                         => "AE",
        "Country: United Kingdom"                               => "GB",
        "Country: United States"                                => "US",
        "Country: United States Minor Outlying Islands"         => "UM",
        "Country: Uruguay"                                      => "UY",
        "Country: Uzbekistan"                                   => "UZ",
        "Country: Vanuatu"                                      => "VU",
        "Country: Venezuela, Bolivarian Republic of"            => "VE",
        "Country: Viet Nam"                                     => "VN",
        "Country: Virgin Islands, British"                      => "VG",
        "Country: Virgin Islands, U.S."                         => "VI",
        "Country: Wallis and Futuna"                            => "WF",
        "Country: Western Sahara"                               => "EH",
        "Country: Yemen"                                        => "YE",
        "Country: Zambia"                                       => "ZM",
        "Country: Zimbabwe"                                     => "ZW",
    );
    
    // Button Styles
    $this->TS_VCSC_Button_Square = array (
        "Gray / 3D - Square"                                    => "ts-button-3d",
        "Gray / Default - Square"                               => "ts-button-default",
        "Gray / Default - Square (Glow)"                        => "ts-button-default glow",
        "Gray / Flat - Square"                                  => "ts-button-flat",
        "Gray / Flat - Square (Glow)"                           => "ts-button-flat glow",
        "Blue / 3D - Square"                                    => "ts-button-3d-primary",
        "Blue / Default - Square"                               => "ts-button-default ts-button-primary",
        "Blue / Default - Square (Glow)"                        => "ts-button-default glow ts-button-primary",
        "Blue / Flat - Square"                                  => "ts-button-flat-primary",
        "Blue / Flat - Square (Glow)"                           => "ts-button-flat-primary glow",
        "Green / 3D - Square"                                   => "ts-button-3d-action",
        "Green / Default - Square"                              => "ts-button-default ts-button-action",
        "Green / Default - Square (Glow)"                       => "ts-button-default glow ts-button-action",
        "Green / Flat - Square"                                 => "ts-button-flat-action",
        "Green / Flat - Square (Glow)"                          => "ts-button-flat-action glow",
        "Orange / 3D - Square"                                  => "ts-button-3d-highlight",
        "Orange / Default - Square"                             => "ts-button-default ts-button-highlight",
        "Orange / Default - Square (Glow)"                      => "ts-button-default glow ts-button-highlight",
        "Orange / Flat - Square"                                => "ts-button-flat-highlight",
        "Orange / Flat - Square (Glow)"                         => "ts-button-flat-highlight glow",
        "Red / 3D - Square"                                     => "ts-button-3d-caution",
        "Red / Default - Square"                                => "ts-button-default ts-button-caution",
        "Red / Default - Square (Glow)"                         => "ts-button-default glow ts-button-caution",
        "Red / Flat - Square"                                   => "ts-button-flat-caution",
        "Red / Flat - Square (Glow)"                            => "ts-button-flat-caution glow",
        "Purple / 3D - Square"                                  => "ts-button-3d-royal",
        "Purple / Default - Square"                             => "ts-button-default ts-button-royal",
        "Purple / Default - Square (Glow)"                      => "ts-button-default glow ts-button-royal",
        "Purple / Flat - Square"                                => "ts-button-flat-royal",
        "Purple / Flat - Square (Glow)"                         => "ts-button-flat-royal glow",
    );
    $this->TS_VCSC_Button_Rounded = array (
        "Gray / 3D - Rounded"                                   => "ts-button-3d ts-button-rounded",
        "Gray / Default - Rounded"                              => "ts-button-rounded ts-button-default",
        "Gray / Default - Rounded (Glow)"                       => "ts-button-rounded ts-button-default glow",
        "Gray / Flat - Rounded"                                 => "ts-button-rounded ts-button-flat",
        "Gray / Flat - Rounded (Glow)"                          => "ts-button-rounded ts-button-flat glow",
        "Blue / 3D - Rounded"                                   => "ts-button-3d-primary ts-button-rounded",
        "Blue / Default - Rounded"                              => "ts-button-rounded-primary ts-button-default",
        "Blue / Default - Rounded (Glow)"                       => "ts-button-rounded-primary ts-button-default",
        "Blue / Flat - Rounded"                                 => "ts-button-rounded ts-button-flat-primary",
        "Blue / Flat - Rounded (Glow)"                          => "ts-button-rounded ts-button-flat-primary glow",
        "Green / 3D - Rounded"                                  => "ts-button-3d-action ts-button-rounded",
        "Green / Default - Rounded"                             => "ts-button-rounded ts-button-default ts-button-action",
        "Green / Default - Rounded (Glow)"                      => "ts-button-rounded ts-button-default glow ts-button-action",
        "Green / Flat - Rounded"                                => "ts-button-rounded ts-button-flat-action",
        "Green / Flat - Rounded (Glow)"                         => "ts-button-rounded ts-button-flat-action glow",
        "Orange / 3D - Rounded"                                 => "ts-button-3d-highlight ts-button-rounded",
        "Orange / Default - Rounded"                            => "ts-button-rounded ts-button-default ts-button-highlight",
        "Orange / Default - Rounded (Glow)"                     => "ts-button-rounded ts-button-default glow ts-button-highlight",
        "Orange / Flat - Rounded"                               => "ts-button-rounded ts-button-flat-highlight",
        "Orange / Flat - Rounded (Glow)"                        => "ts-button-rounded ts-button-flat-highlight glow",
        "Red / 3D - Rounded"                                    => "ts-button-3d-caution ts-button-rounded",
        "Red / Default - Rounded"                               => "ts-button-rounded ts-button-default ts-button-caution",
        "Red / Default - Rounded (Glow)"                        => "ts-button-rounded ts-button-default glow ts-button-caution",
        "Red / Flat - Rounded"                                  => "ts-button-rounded ts-button-flat-caution",
        "Red / Flat - Rounded (Glow)"                           => "ts-button-rounded ts-button-flat-caution glow",
        "Purple / 3D - Rounded"                                 => "ts-button-3d-royal ts-button-rounded",
        "Purple / Default - Rounded"                            => "ts-button-rounded ts-button-default ts-button-royal",
        "Purple / Default - Rounded (Glow)"                     => "ts-button-rounded ts-button-default glow ts-button-royal",
        "Purple / Flat - Rounded"                               => "ts-button-rounded ts-button-flat-royal",
        "Purple / Flat - Rounded (Glow)"                        => "ts-button-rounded ts-button-flat-royal glow",
    );
    $this->TS_VCSC_Button_Pill = array (
        "Gray / 3D - Pill"                                      => "ts-button-3d ts-button-pill",
        "Gray / Default - Pill"                                 => "ts-button-pill ts-button-default",
        "Gray / Default - Pill (Glow)"                          => "ts-button-pill ts-button-default glow",
        "Gray / Flat - Pill"                                    => "ts-button-pill ts-button-flat",
        "Gray / Flat - Pill (Glow)"                             => "ts-button-pill ts-button-flat glow",
        "Blue / 3D - Pill"                                      => "ts-button-3d-primary ts-button-pill",
        "Blue / Default - Pill"                                 => "ts-button-pill ts-button-primary",
        "Blue / Default - Pill (Glow)"                          => "ts-button-pill ts-button-primary glow",
        "Blue / Flat - Pill"                                    => "ts-button-pill ts-button-flat-primary",
        "Blue / Flat - Pill (Glow)"                             => "ts-button-pill ts-button-flat-primary glow",
        "Green / 3D - Pill"                                     => "ts-button-3d-action ts-button-pill",
        "Green / Default - Pill"                                => "ts-button-pill ts-button-default ts-button-action",
        "Green / Default - Pill (Glow)"                         => "ts-button-pill ts-button-default glow ts-button-action",
        "Green / Flat - Pill"                                   => "ts-button-pill ts-button-flat-action",
        "Green / Flat - Pill (Glow)"                            => "ts-button-pill ts-button-flat-action glow",
        "Orange / 3D - Pill"                                    => "ts-button-3d-highlight ts-button-pill",
        "Orange / Default - Pill"                               => "ts-button-pill ts-button-default ts-button-highlight",
        "Orange / Default - Pill (Glow)"                        => "ts-button-pill ts-button-default glow ts-button-highlight",
        "Orange / Flat - Pill"                                  => "ts-button-pill ts-button-flat-highlight",
        "Orange / Flat - Pill (Glow)"                           => "ts-button-pill ts-button-flat-highlight glow",
        "Red / 3D - Pill"                                       => "ts-button-3d-caution ts-button-pill",
        "Red / Default - Pill"                                  => "ts-button-pill ts-button-default ts-button-caution",
        "Red / Default - Pill (Glow)"                           => "ts-button-pill ts-button-default glow ts-button-caution",
        "Red / Flat - Pill"                                     => "ts-button-pill ts-button-flat-caution",
        "Red / Flat - Pill (Glow)"                              => "ts-button-pill ts-button-flat-caution glow",
        "Purple / 3D - Pill"                                    => "ts-button-3d-royal ts-button-pill",
        "Purple / Default - Pill"                               => "ts-button-pill ts-button-default ts-button-royal",
        "Purple / Default - Pill (Glow)"                        => "ts-button-pill ts-button-default glow ts-button-royal",
        "Purple / Flat - Pill"                                  => "ts-button-pill ts-button-flat-royal",
        "Purple / Flat - Pill (Glow)"                           => "ts-button-pill ts-button-flat-royal glow",
    );
    $this->TS_VCSC_Button_Circle = array (
        "Gray / 3D - Circle"                                    => "ts-button-3d ts-button-circle",
        "Gray / Default - Circle"                               => "ts-button-circle ts-button-default",
        "Gray / Default - Circle (Glow)"                        => "ts-button-circle ts-button-default glow",
        "Gray / Flat - Circle"                                  => "ts-button-circle ts-button-flat",
        "Gray / Flat - Circle (Glow)"                           => "ts-button-circle ts-button-flat glow",
        "Blue / 3D - Circle"                                    => "ts-button-3d-primary ts-button-circle",
        "Blue / Default - Circle"                               => "ts-button-circle ts-button-primary",
        "Blue / Default - Circle (Glow)"                        => "ts-button-circle ts-button-primary glow",
        "Blue / Flat - Circle"                                  => "ts-button-circle ts-button-flat-primary",
        "Blue / Flat - Circle (Glow)"                           => "ts-button-circle ts-button-flat-primary glow",
        "Green / 3D - Circle"                                   => "ts-button-3d-action ts-button-circle",
        "Green / Default - Circle"                              => "ts-button-circle ts-button-default ts-button-action",
        "Green / Default - Circle (Glow)"                       => "ts-button-circle ts-button-default glow ts-button-action",
        "Green / Flat - Circle"                                 => "ts-button-circle ts-button-flat-action",
        "Green / Flat - Circle (Glow)"                          => "ts-button-circle ts-button-flat-action glow",
        "Orange / 3D - Circle"                                  => "ts-button-3d-highlight ts-button-circle",
        "Orange / Default - Circle"                             => "ts-button-circle ts-button-default ts-button-highlight",
        "Orange / Default - Circle (Glow)"                      => "ts-button-circle ts-button-default glow ts-button-highlight",
        "Orange / Flat - Circle"                                => "ts-button-circle ts-button-flat-highlight",
        "Orange / Flat - Circle (Glow)"                         => "ts-button-circle ts-button-flat-highlight glow",
        "Red / 3D - Circle"                                     => "ts-button-3d-caution ts-button-circle",
        "Red / Default - Circle"                                => "ts-button-circle ts-button-default ts-button-caution",
        "Red / Default - Circle (Glow)"                         => "ts-button-circle ts-button-default glow ts-button-caution",
        "Red / Flat - Circle"                                   => "ts-button-circle ts-button-flat-caution",
        "Red / Flat - Circle (Glow)"                            => "ts-button-circle ts-button-flat-caution glow",
        "Purple / 3D - Circle"                                  => "ts-button-3d-royal ts-button-circle",
        "Purple / Default - Circle"                             => "ts-button-circle ts-button-default ts-button-royal",
        "Purple / Default - Circle (Glow)"                      => "ts-button-circle ts-button-default glow ts-button-royal",
        "Purple / Flat - Circle"                                => "ts-button-circle ts-button-flat-royal",
        "Purple / Flat - Circle (Glow)"                         => "ts-button-circle ts-button-flat-royal glow",
    );    
    $this->TS_VCSC_Flat_Button_Default_Colors = array(
        "Default Flat"			                                => "ts-dual-buttons-color-default",
        "Sun Flower Flat"		                                => "ts-dual-buttons-color-sun-flower",
        "Orange Flat"			                                => "ts-dual-buttons-color-orange-flat",
        "Carot Flat"     		                                => "ts-dual-buttons-color-carrot-flat",
        "Pumpkin Flat"			                                => "ts-dual-buttons-color-pumpkin-flat",
        "Alizarin Flat"			                                => "ts-dual-buttons-color-alizarin-flat",
        "Pomegranate Flat"		                                => "ts-dual-buttons-color-pomegranate-flat",
        "Turquoise Flat"			                            => "ts-dual-buttons-color-turquoise-flat",
        "Green Sea Flat"			                            => "ts-dual-buttons-color-green-sea-flat",
        "Emerald Flat"			                                => "ts-dual-buttons-color-emerald-flat",
        "Nephritis Flat"			                            => "ts-dual-buttons-color-nephritis-flat",
        "Peter River Flat"		                                => "ts-dual-buttons-color-peter-river-flat",
        "Belize Hole Flat"		                                => "ts-dual-buttons-color-belize-hole-flat",
        "Amethyst Flat"			                                => "ts-dual-buttons-color-amethyst-flat",
        "Wisteria Flat"			                                => "ts-dual-buttons-color-wisteria-flat",
        "Wet Asphalt Flat"		                                => "ts-dual-buttons-color-wet-asphalt-flat",
        "Midnight Blue Flat"		                            => "ts-dual-buttons-color-midnight-blue-flat",
        "Clouds Flat"			                                => "ts-dual-buttons-color-clouds-flat",
        "Silver Flat"			                                => "ts-dual-buttons-color-silver-flat",
        "Concrete Flat"			                                => "ts-dual-buttons-color-concrete-flat",
        "Asbestos Flat"			                                => "ts-dual-buttons-color-asbestos-flat",
        "Graphite Flat"			                                => "ts-dual-buttons-color-graphite-flat",
    );
    $this->TS_VCSC_Flat_Button_Default_Custom = array(
        __( 'Custom Color Style', "ts_visual_composer_extend" ) => "ts-dual-buttons-color-custom-flat",
    );
    $this->TS_VCSC_Flat_Button_Hover_Colors = array(
        "Default Flat"			                                => "ts-dual-buttons-preview-default ts-dual-buttons-hover-default",
        "Sun Flower Flat"		                                => "ts-dual-buttons-preview-sun-flower ts-dual-buttons-hover-sun-flower",
        "Orange Flat"			                                => "ts-dual-buttons-preview-orange-flat ts-dual-buttons-hover-orange-flat",
        "Carot Flat"     		                                => "ts-dual-buttons-preview-carrot-flat ts-dual-buttons-hover-carrot-flat",
        "Pumpkin Flat"			                                => "ts-dual-buttons-preview-pumpkin-flat ts-dual-buttons-hover-pumpkin-flat",
        "Alizarin Flat"			                                => "ts-dual-buttons-preview-alizarin-flat ts-dual-buttons-hover-alizarin-flat",
        "Pomegranate Flat"		                                => "ts-dual-buttons-preview-pomegranate-flat ts-dual-buttons-hover-pomegranate-flat",
        "Turquoise Flat"			                            => "ts-dual-buttons-preview-turquoise-flat ts-dual-buttons-hover-turquoise-flat",
        "Green Sea Flat"			                            => "ts-dual-buttons-preview-green-sea-flat ts-dual-buttons-hover-green-sea-flat",
        "Emerald Flat"			                                => "ts-dual-buttons-preview-emerald-flat ts-dual-buttons-hover-emerald-flat",
        "Nephritis Flat"			                            => "ts-dual-buttons-preview-nephritis-flat ts-dual-buttons-hover-nephritis-flat",
        "Peter River Flat"		                                => "ts-dual-buttons-preview-peter-river-flat ts-dual-buttons-hover-peter-river-flat",
        "Belize Hole Flat"		                                => "ts-dual-buttons-preview-belize-hole-flat ts-dual-buttons-hover-belize-hole-flat",
        "Amethyst Flat"			                                => "ts-dual-buttons-preview-amethyst-flat ts-dual-buttons-hover-amethyst-flat",
        "Wisteria Flat"			                                => "ts-dual-buttons-preview-wisteria-flat ts-dual-buttons-hover-wisteria-flat",
        "Wet Asphalt Flat"		                                => "ts-dual-buttons-preview-wet-asphalt-flat ts-dual-buttons-hover-wet-asphalt-flat",
        "Midnight Blue Flat"		                            => "ts-dual-buttons-preview-midnight-blue-flat ts-dual-buttons-hover-midnight-blue-flat",
        "Clouds Flat"			                                => "ts-dual-buttons-preview-clouds-flat ts-dual-buttons-hover-clouds-flat",
        "Silver Flat"			                                => "ts-dual-buttons-preview-silver-flat ts-dual-buttons-hover-silver-flat",
        "Concrete Flat"			                                => "ts-dual-buttons-preview-concrete-flat ts-dual-buttons-hover-concrete-flat",
        "Asbestos Flat"			                                => "ts-dual-buttons-preview-asbestos-flat ts-dual-buttons-hover-asbestos-flat",
        "Graphite Flat"			                                => "ts-dual-buttons-preview-graphite-flat ts-dual-buttons-hover-graphite-flat",
    );
    $this->TS_VCSC_Flat_Button_Hover_Custom = array(
        __( 'Custom Color Style', "ts_visual_composer_extend" ) => "ts-dual-buttons-preview-custom-flat ts-dual-buttons-hover-custom-flat",
    );
    
    // Define Array for Border Types
    $this->TS_VCSC_Border_Type_Values = array(
        'solid', 'dotted', 'dashed', 'double', 'groove', 'ridge', 'inset', 'outset'
    );
    
    // Define Array for Icon Border Radius
    $this->TS_VCSC_Icon_Border_Radius_Values = array(
        'ts-radius-small', 'ts-radius-medium', 'ts-radius-large', 'ts-radius-full'
    );
    
    // Define Array for Box Border Radius
    $this->TS_VCSC_Box_Border_Radius_Values = array(
        'ts-radius-small', 'ts-radius-medium', 'ts-radius-large'
    );
    
    // Define Array for WP Bakery Page Builder CSS Animations
    $this->TS_VCSC_CSS_Animations_Values = array(
        'appear', 'fade-in', 'scale-up', 'right-to-left', 'left-to-right', 'bottom-to-top', 'top-to-bottom'
    );
    
    // Define Arrays for jQuery Easings
    $this->TS_VCSC_CSS_Easings_Array = array(
		"Linear"					    => "linear",
		"Ease In Sine"			        => "easeInSine",
		"Ease Out Sine"			        => "easeOutSine",
        "Ease In Out Sine"              => "easeInOutSine",
		"Ease In Quad"			        => "easeInQuad",
        "Ease Out Quad"			        => "easeOutQuad",
        "Ease In Out Quad"              => "easeInOutQuad",
        "Ease In Cubic"			        => "easeInCubic",
        "Ease Out Cubic"                => "easeOutCubic",
        "Ease In Out Cubic"             => "easeInOutCubic",
        "Ease In Quart"			        => "easeInQuart",
        "Ease Out Quart"                => "easeOutQuart",
        "Ease In Out Quart"             => "easeInOutQuart",        
        "Ease In Quint"			        => "easeInQuint",
        "Ease Out Quint"                => "easeOutQuint",
        "Ease In Out Quint"             => "easeInOutQuint",        
        "Ease In Expo"			        => "easeInExpo",
        "Ease Out Expo"                 => "easeOutExpo",
        "Ease In Out Expo"              => "easeInOutExpo",        
        "Ease In Circ"			        => "easeInCirc",
        "Ease Out Circ"                 => "easeOutCirc",
        "Ease In Out Circ"              => "easeInOutCirc",
        "Ease In Back"			        => "easeInBack",
        "Ease Out Back"                 => "easeOutBack",
        "Ease In Out Back"              => "easeInOutBack",        
        "Ease In Elastic"               => "easeInElastic",
        "Ease Out Elastic"              => "easeOutElastic",
        "Ease In Out Elastic"           => "easeInOutElastic",
        "Ease In Bounce"                => "easeInBounce",
        "Ease Out Bounce"               => "easeOutBounce",
        "Ease In Out Bounce"            => "easeInOutBounce",
    );
    
    // Define Array for Background Styles
    $this->TS_VCSC_Background_Type_Values = array(
        'color', 'pattern'
    );
    
    // Define Arrays for Tooltipster Styles
    $this->TS_VCSC_ToolTipster_Styles = array(
        __( "Black", "ts_visual_composer_extend" )                                  => "ts-simptip-style-black",
        __( "Gray", "ts_visual_composer_extend" )                                   => "ts-simptip-style-gray",
        __( "Green", "ts_visual_composer_extend" )                                  => "ts-simptip-style-green",
        __( "Blue", "ts_visual_composer_extend" )                                   => "ts-simptip-style-blue",
        __( "Red", "ts_visual_composer_extend" )                                    => "ts-simptip-style-red",
        __( "Orange", "ts_visual_composer_extend" )                                 => "ts-simptip-style-orange",
        __( "Yellow", "ts_visual_composer_extend" )                                 => "ts-simptip-style-yellow",
        __( "Purple", "ts_visual_composer_extend" )                                 => "ts-simptip-style-purple",
        __( "Pink", "ts_visual_composer_extend" )                                   => "ts-simptip-style-pink",
        __( "White", "ts_visual_composer_extend" )                                  => "ts-simptip-style-white",
        __( "Custom", "ts_visual_composer_extend" )                                 => "ts-simptip-style-custom",
    );    
    $this->TS_VCSC_ToolTipster_Layouts = array(
        __( "Black", "ts_visual_composer_extend" )                                  => "ts-simptip-style-black",
        __( "Gray", "ts_visual_composer_extend" )                                   => "ts-simptip-style-gray",
        __( "Green", "ts_visual_composer_extend" )                                  => "ts-simptip-style-green",
        __( "Blue", "ts_visual_composer_extend" )                                   => "ts-simptip-style-blue",
        __( "Red", "ts_visual_composer_extend" )                                    => "ts-simptip-style-red",
        __( "Orange", "ts_visual_composer_extend" )                                 => "ts-simptip-style-orange",
        __( "Yellow", "ts_visual_composer_extend" )                                 => "ts-simptip-style-yellow",
        __( "Purple", "ts_visual_composer_extend" )                                 => "ts-simptip-style-purple",
        __( "Pink", "ts_visual_composer_extend" )                                   => "ts-simptip-style-pink",
        __( "White", "ts_visual_composer_extend" )                                  => "ts-simptip-style-white",
    );
    
    // Define Arrays for Tooltipster Positions
    $this->TS_VCSC_ToolTipster_Positions = array(
		__("Top", "ts_visual_composer_extend")                                      => "ts-simptip-position-top",
		__("Bottom", "ts_visual_composer_extend")                                   => "ts-simptip-position-bottom",
		__("Left", "ts_visual_composer_extend")                                     => "ts-simptip-position-left",
		__("Right", "ts_visual_composer_extend")                                    => "ts-simptip-position-right",
    );
    $this->TS_VCSC_ToolTipster_Vertical = array(
		__("Top", "ts_visual_composer_extend")                                      => "ts-simptip-position-top",
		__("Bottom", "ts_visual_composer_extend")                                   => "ts-simptip-position-bottom",
    );
    $this->TS_VCSC_ToolTipster_Horizontal = array(
		__("Left", "ts_visual_composer_extend")                                     => "ts-simptip-position-left",
		__("Right", "ts_visual_composer_extend")                                    => "ts-simptip-position-right",
    );
    
    // Define Array for Tooltipster Animations 
    $this->TS_VCSC_ToolTipster_Animations = array(
        __("Swing", "ts_visual_composer_extend")                                    => "swing",
        __("Fall", "ts_visual_composer_extend")                 	                => "fall",
        __("Grow", "ts_visual_composer_extend")                 	                => "grow",
        __("Slide", "ts_visual_composer_extend")                 	                => "slide",
        __("Fade", "ts_visual_composer_extend")                 	                => "fade",
    );
    
    // Define Array for SVG Shapes
    $this->TS_VCSC_SVG_RowShapes_List = array(
        //'No Effect (Square)'                          => '0',
        'Triangle Inwards'                              => '1',
        'Triangle Outwards'                             => '2',
        'Slight Center Curve Inwards'                   => '3',
        'Slight Left Curve Inwards'                     => '4',
        'Slight Right Curve Inwards'                    => '5',
        'Sharp Left Curve Inwards'                      => '6',
        'Sharp Right Curve Inwards'                     => '7',
        'Sharp Left Line Inwards'                       => '8',
        'Sharp Right Line Inwards'                      => '9',
        'Inwards Wave Pattern'                          => '10',
        'Inwards Cloud Pattern'                         => '11',
        'Simple Cloud Pattern'                          => '12',
        'Stamps'                                        => '13',
        'Slits'                                         => '14',        
        'Big Triangle'                                  => '15',
        'Big Triangle with Shadow'                      => '16',        
        'Curve Up'                                      => '17',
        'Curve Down'                                    => '18',
        'Big Half Circle'                               => '19',
        // Basic Diagonals
        'Diagonal (Upper; Full Left - None Right)'      => '20',
        'Diagonal (Upper; None Left - Full Right)'      => '21',
        'Diagonal (Lower; Full Left - None Right)'      => '22',
        'Diagonal (Lower; None Left - Full Right)'      => '23',
        // Resizable Center Arrows
        'Top Center Arrow Out'                          => '24',
        'Top Center Arrow In'                           => '25',        
        'Bottom Center Arrow Out'                       => '26',
        'Bottom Center Arrow In'                        => '27',
    );
    $this->TS_VCSC_SVG_RowShapes_FlipMe = array('1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19');
    
    // Define Array for Backgrounds
    $this->TS_VCSC_Background_List = array(
        ''                              => '',
        'P00'                           => 'images/pattern/00.jpg',
        'P01'                           => 'images/pattern/01.jpg',
        'P02'                           => 'images/pattern/02.jpg',
        'P03'                           => 'images/pattern/03.jpg',
        'P04'                           => 'images/pattern/04.jpg',
        'P05'                           => 'images/pattern/05.jpg',
        'P06'                           => 'images/pattern/06.jpg',
        'P07'                           => 'images/pattern/07.jpg',
        'P08'                           => 'images/pattern/08.jpg',
        'P09'                           => 'images/pattern/09.jpg',
        'P10'                           => 'images/pattern/10.jpg',
        'P11'                           => 'images/pattern/11.jpg',
        'P12'                           => 'images/pattern/12.jpg',
        'P13'                           => 'images/pattern/13.jpg',
        'P14'                           => 'images/pattern/14.jpg',
        'P15'                           => 'images/pattern/15.jpg',
        'P16'                           => 'images/pattern/16.jpg',
        'P17'                           => 'images/pattern/17.jpg',
        'P18'                           => 'images/pattern/18.jpg',
        'P19'                           => 'images/pattern/19.jpg',
        'P20'                           => 'images/pattern/20.jpg',
        'P21'                           => 'images/pattern/21.jpg',
        'P22'                           => 'images/pattern/22.jpg',
        'P23'                           => 'images/pattern/23.jpg',
        'P24'                           => 'images/pattern/24.jpg',
        'P25'                           => 'images/pattern/25.jpg',
        'P26'                           => 'images/pattern/26.jpg',
        'P27'                           => 'images/pattern/27.jpg',
        'P28'                           => 'images/pattern/28.jpg',
        'P29'                           => 'images/pattern/29.jpg',
        'P30'                           => 'images/pattern/30.jpg',
        'P31'                           => 'images/pattern/31.jpg',
        'P32'                           => 'images/pattern/32.jpg',
        'P33'                           => 'images/pattern/33.jpg',
        'P34'                           => 'images/pattern/34.jpg',
        'P35'                           => 'images/pattern/35.jpg',
        'P36'                           => 'images/pattern/36.jpg',
        'P37'                           => 'images/pattern/37.jpg',
        'P38'                           => 'images/pattern/38.jpg',
        'P39'                           => 'images/pattern/39.jpg',
        'P40'                           => 'images/pattern/40.jpg',
        'P41'                           => 'images/pattern/41.jpg',
        'P42'                           => 'images/pattern/42.jpg',
        'P43'                           => 'images/pattern/43.jpg',
        'P44'                           => 'images/pattern/44.jpg',
        'P45'                           => 'images/pattern/45.jpg',
        'P46'                           => 'images/pattern/46.jpg',
        'P47'                           => 'images/pattern/47.jpg',
        'P48'                           => 'images/pattern/48.jpg',
        'P49'                           => 'images/pattern/49.jpg',
        'P50'                           => 'images/pattern/50.jpg',
        'P51'                           => 'images/pattern/51.jpg',
        'P52'                           => 'images/pattern/52.jpg',
        'P53'                           => 'images/pattern/53.jpg',
        'P54'                           => 'images/pattern/54.jpg',
        'P55'                           => 'images/pattern/55.jpg',
        'P56'                           => 'images/pattern/56.jpg',
        'P57'                           => 'images/pattern/57.jpg',
        'P58'                           => 'images/pattern/58.jpg',
        'P59'                           => 'images/pattern/59.jpg',
        'P60'                           => 'images/pattern/60.jpg',
        'P61'                           => 'images/pattern/61.jpg',
        'P62'                           => 'images/pattern/62.jpg',
        'P63'                           => 'images/pattern/63.jpg',
        'P64'                           => 'images/pattern/64.jpg',
        'P65'                           => 'images/pattern/65.jpg',
        'P66'                           => 'images/pattern/66.jpg',
        'P67'                           => 'images/pattern/67.jpg',
        'P68'                           => 'images/pattern/68.jpg',
        'P69'                           => 'images/pattern/69.jpg',
        'P70'                           => 'images/pattern/70.jpg',
        'P71'                           => 'images/pattern/71.jpg',
        'P72'                           => 'images/pattern/72.jpg',
        'P73'                           => 'images/pattern/73.jpg',
        'P74'                           => 'images/pattern/74.jpg',
        'P75'                           => 'images/pattern/75.jpg',
        'P76'                           => 'images/pattern/76.jpg',
        'P77'                           => 'images/pattern/77.jpg',
        'P78'                           => 'images/pattern/78.jpg',
        'P79'                           => 'images/pattern/79.jpg',
        'P80'                           => 'images/pattern/80.jpg',
        'P81'                           => 'images/pattern/81.jpg',
        'P82'                           => 'images/pattern/82.jpg',
        'P83'                           => 'images/pattern/83.jpg',
        'P84'                           => 'images/pattern/84.jpg',
        'P85'                           => 'images/pattern/85.jpg',
        'P86'                           => 'images/pattern/86.jpg',
        'P87'                           => 'images/pattern/87.jpg',
        'P88'                           => 'images/pattern/88.jpg',
        'P89'                           => 'images/pattern/89.jpg',
        'P90'                           => 'images/pattern/90.jpg',
        'P91'                           => 'images/pattern/91.jpg',
        'P92'                           => 'images/pattern/92.jpg',
        'P93'                           => 'images/pattern/93.jpg',
        'P94'                           => 'images/pattern/94.jpg',
        'P95'                           => 'images/pattern/95.jpg',
        'P96'                           => 'images/pattern/96.jpg',
        'P97'                           => 'images/pattern/97.jpg',
        'P98'                           => 'images/pattern/98.jpg',
        'P99'                           => 'images/pattern/99.jpg',
    );
    
    // Define Array for Raster Images
    $this->TS_VCSC_Rasters_List = array(
        ''                              => '',
        'R00'                           => 'images/rasters/00.png',
        'R01'                           => 'images/rasters/01.png',
        'R02'                           => 'images/rasters/02.png',
        'R03'                           => 'images/rasters/03.png',
        'R04'                           => 'images/rasters/04.png',
        'R05'                           => 'images/rasters/05.png',
        'R06'                           => 'images/rasters/06.png',
        'R07'                           => 'images/rasters/07.png',
        'R08'                           => 'images/rasters/08.png',
        'R09'                           => 'images/rasters/09.png',
        'R10'                           => 'images/rasters/10.png',
        'R11'                           => 'images/rasters/11.png',
        'R12'                           => 'images/rasters/12.png',
        'R13'                           => 'images/rasters/13.png',
        'R14'                           => 'images/rasters/14.png',
        'R15'                           => 'images/rasters/15.png',
        'R16'                           => 'images/rasters/16.png',
        'R17'                           => 'images/rasters/17.png',
        'R18'                           => 'images/rasters/18.png',
        'R19'                           => 'images/rasters/19.png',
        'R20'                           => 'images/rasters/20.png',
        'R21'                           => 'images/rasters/21.png',
        'R22'                           => 'images/rasters/22.png',
        'R23'                           => 'images/rasters/23.png',
        'R24'                           => 'images/rasters/24.png',
        'R25'                           => 'images/rasters/25.png',
        'R26'                           => 'images/rasters/26.png',
        'R27'                           => 'images/rasters/27.png',
        'R28'                           => 'images/rasters/28.png',
        'R29'                           => 'images/rasters/29.png',
        'R30'                           => 'images/rasters/30.png',
        'R31'                           => 'images/rasters/31.png',
        'R32'                           => 'images/rasters/32.png',
        'R33'                           => 'images/rasters/33.png',
        'R34'                           => 'images/rasters/34.png',
    );
    
    // Define Array for Bullet Images
    $this->TS_VCSC_Bullets_List = array(
        'B00'                           => 'images/bullets/bullet_arrow_black.png',
        'B01'                           => 'images/bullets/bullet_arrow_blue.png',
        'B02'                           => 'images/bullets/bullet_arrow_gray.png',
        'B03'                           => 'images/bullets/bullet_arrow_green.png',
        'B04'                           => 'images/bullets/bullet_arrow_red.png',
        'B05'                           => 'images/bullets/bullet_arrow_yellow.png',
        'B06'                           => 'images/bullets/bullet_check_black.png',
        'B07'                           => 'images/bullets/bullet_check_blue.png',
        'B08'                           => 'images/bullets/bullet_check_gray.png',
        'B09'                           => 'images/bullets/bullet_check_green.png',
        'B10'                           => 'images/bullets/bullet_check_red.png',
        'B11'                           => 'images/bullets/bullet_check_yellow.png',
        'B12'                           => 'images/bullets/bullet_cross_black.png',
        'B13'                           => 'images/bullets/bullet_cross_blue.png',
        'B14'                           => 'images/bullets/bullet_cross_gray.png',
        'B15'                           => 'images/bullets/bullet_cross_green.png',
        'B16'                           => 'images/bullets/bullet_cross_red.png',
        'B17'                           => 'images/bullets/bullet_cross_yellow.png',
        'B18'                           => 'images/bullets/bullet_minus_black.png',
        'B19'                           => 'images/bullets/bullet_minus_blue.png',
        'B20'                           => 'images/bullets/bullet_minus_gray.png',
        'B21'                           => 'images/bullets/bullet_minus_green.png',
        'B22'                           => 'images/bullets/bullet_minus_red.png',
        'B23'                           => 'images/bullets/bullet_minus_yellow.png',
        'B24'                           => 'images/bullets/bullet_plus_black.png',
        'B25'                           => 'images/bullets/bullet_plus_blue.png',
        'B26'                           => 'images/bullets/bullet_plus_gray.png',
        'B27'                           => 'images/bullets/bullet_plus_green.png',
        'B28'                           => 'images/bullets/bullet_plus_red.png',
        'B29'                           => 'images/bullets/bullet_plus_yellow.png',
    );
    
    // PHP End Of Life Data
    $this->TS_VCSC_PHP_End_Of_Life = array(
        '5.5'                           => '07/21/2016',
        '5.4'                           => '09/03/2015',
        '5.3'                           => '08/14/2014',
        '5.2'                           => '01/06/2011',
        '5.1'                           => '08/24/2006',
        '5.0'                           => '09/05/2005',
        '4.4'                           => '08/07/2008',
        '4.3'                           => '03/31/2005',
        '4.2'                           => '09/06/2002',
        '4.1'                           => '03/12/2002',
        '4.0'                           => '06/23/2001',
        '3.0'                           => '10/20/2000',
    );
?>